﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class CompetencePart_Class : PI.FM.N000.Base.BL.DBD.BaseTable<BO.CompetencePart_Class>
    {
        #region Static factory
        private static CompetencePart_Class _factory = null;

        public static CompetencePart_Class DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new CompetencePart_Class();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_CompetencePart_Class";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("ClassID", "ClassID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetencePartID", "CompetencePartID"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsAvailable", "IsAvailable"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10,
            RemoveBySearch = 11,
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
                case (int)Commands.RemoveBySearch: return new Command_RemoveBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.CompetencePart_Class>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.CompetencePart_Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetencePartID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_CompetencePart_Class_RestoreBySearch";
            }
        }

        class Command_RemoveBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.CompetencePart_Class>
        {
            public Command_RemoveBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.CompetencePart_Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetencePartID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("EditDate", Gemini.Core.BL.DAL.SqlTypes.DateTime));
                Add(new Gemini.Core.BL.DBD.Param("EditUser", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_CompetencePart_Class_RemoveBySearch";
            }
        }
        #endregion
    }
}